within Physiolibrary;
package Icons "Icons for physiological models"
  //extends Modelica.Icons.IconsPackage;
  extends Modelica.Icons.Package;
  package Library
      extends Modelica.Icons.Package;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics));
  end Library;

  model Golem

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,98},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/golem.png")}));
  end Golem;

  model CardioVascular

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/csv.png")}));
  end CardioVascular;

  model Water

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/indexVoda.png")}));
  end Water;

  model Electrolytes

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/electrolytes.png")}));
  end Electrolytes;

  model Proteins

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-98,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/protein.png")}));
  end Proteins;

  model Gases

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/gases.png")}));
  end Gases;

  model NutrientsMetabolism

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/vyziva.png")}));
  end NutrientsMetabolism;

  model Heat

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/ohen.png")}));
  end Heat;

  model Hormones

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/hormony.png")}));
  end Hormones;

  model Nerves

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/nervyNeuron.png")}));
  end Nerves;

  model Setup

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/setup.png")}));
  end Setup;

  model Status

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-98,-100},{100,
                100}}, fileName="modelica://Physiolibrary/Resources/Icons/tissueFitness.png")}));
  end Status;

  model SkeletalMuscle

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-70,92},{40,-80}},
              fileName="modelica://Physiolibrary/Resources/Icons/sval.png")}));
  end SkeletalMuscle;

  model Bone

    annotation (Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,
              -100},{100,100}}), graphics={Rectangle(
            extent={{-100,100},{100,-100}},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None), Bitmap(extent={{-88,96},{52,-84}},
              fileName="modelica://Physiolibrary/Resources/Icons/bone.png")}));
  end Bone;

  model OtherTissue

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-74,60},{48,-94}},
              fileName="modelica://Physiolibrary/Resources/Icons/pojivovaTkan.png")}));
  end OtherTissue;

  model RespiratoryMuscle

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-66,86},{44,-86}},
              fileName="modelica://Physiolibrary/Resources/Icons/respiracniSvaly.png")}));
  end RespiratoryMuscle;

  model Fat

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-84,86},{38,-68}},
              fileName="modelica://Physiolibrary/Resources/Icons/tukovaBunka.png")}));
  end Fat;

  model Skin

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-74,56},{48,-84}},
              fileName="modelica://Physiolibrary/Resources/Icons/skin.png")}));
  end Skin;

  model Brain

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-78,62},{44,-92}},
              fileName="modelica://Physiolibrary/Resources/Icons/brain.png")}));
  end Brain;

  model GITract

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-80,74},{42,-80}},
              fileName="modelica://Physiolibrary/Resources/Icons/traviciTrakt.png")}));
  end GITract;

  model LeftHeart

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
              {100,100}}),        graphics={Bitmap(extent={{-96,100},{24,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/srdceLeva.png")}), Diagram(
          coordinateSystem(extent={{-100,-100},{100,100}})));
  end LeftHeart;

  model RightHeart

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
              {100,100}}),       graphics={Bitmap(extent={{-26,66},{92,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/srdceprava.png")}), Diagram(
          coordinateSystem(extent={{-100,-100},{100,100}})));
  end RightHeart;

  model Liver

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-84,34},{86,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/jatra.png")}));
  end Liver;

  model Kidney

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-92,86},{40,-88}},
              fileName="modelica://Physiolibrary/Resources/Icons/kidney.png")}));
  end Kidney;

  model Bladder

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Rectangle(
            extent={{-100,100},{100,-100}},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None), Bitmap(extent={{-92,86},{40,-88}},
              fileName="modelica://Physiolibrary/Resources/Icons/mocovyMechyr.png")}));
  end Bladder;

  model GILumen

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/traviciTrakt2.png")}));
  end GILumen;

  model ThyroidGland

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-92,86},{40,-88}},
              fileName="modelica://Physiolibrary/Resources/Icons/stitnaZlaza.png")}));
  end ThyroidGland;

  model Pancreas

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/pankreas.png")}));
  end Pancreas;

  model AdrenalGland

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/nadledviny.png")}));
  end AdrenalGland;

  model Lungs

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-70,92},{40,-80}},
              fileName="modelica://Physiolibrary/Resources/Icons/plice.png")}));
  end Lungs;

  model Tissues

    annotation (Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,
              -100},{100,100}}), graphics={
          Bitmap(extent={{-46,98},{32,26}}, fileName="modelica://Physiolibrary/Resources/Icons/bone.png"),
          Bitmap(extent={{-62,-10},{50,-92}}, fileName="modelica://Physiolibrary/Resources/Icons/skin.png"),
          Bitmap(extent={{-38,90},{64,-20}}, fileName="modelica://Physiolibrary/Resources/Icons/sval.png"),
          Bitmap(extent={{-10,36},{102,-56}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/traviciTrakt.png"),
          Text(
            extent={{64,-66},{94,-96}},
            lineColor={0,0,0},
            textString="..."),
          Bitmap(extent={{-98,36},{-24,-30}}, fileName="modelica://Physiolibrary/Resources/Icons/brain.png")}));

  end Tissues;

  model Peritoneum

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-70,92},{40,-80}},
              fileName="modelica://Physiolibrary/Resources/Icons/peritoneum.png")}));
  end Peritoneum;

  model Plasma

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-70,92},{40,-80}},
              fileName="modelica://Physiolibrary/Resources/Icons/plazma.png")}));
  end Plasma;

  model Hypophysis

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/hypofyza.png")}));
  end Hypophysis;

  model Heart

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/heart.png")}));
  end Heart;

  model SweatGland

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/potniZlaza.png")}));
  end SweatGland;

  model Cell

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
              {100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/OsmothicCell.png")}));
  end Cell;

  package HeatLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,44},{76,-82}},
              fileName="modelica://Physiolibrary/Resources/Icons/ohen.png")}));

  end HeatLib;

  package StatusLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,-96},{72,40}},
              fileName="modelica://Physiolibrary/Resources/Icons/tissueFitness.png")}));

  end StatusLib;

   package NervesLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,42},{72,-96}},
              fileName="modelica://Physiolibrary/Resources/Icons/nervyNeuron.png")}));

   end NervesLib;

  package NutrientsMetabolismLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-98,40},{80,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/vyziva.png")}));

  end NutrientsMetabolismLib;

  package OxygenLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,42},{78,-98}},
              fileName="modelica://Physiolibrary/Resources/Icons/O2.png")}));
  end OxygenLib;

  package ProteinsLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-98,42},{76,-98}},
              fileName="modelica://Physiolibrary/Resources/Icons/protein.png")}));

  end ProteinsLib;

  package SetupLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-94,44},{72,-98}},
              fileName="modelica://Physiolibrary/Resources/Icons/setup.png")}));

  end SetupLib;

  package CardioVascularLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,42},{76,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/csv.png")}));

  end CardioVascularLib;

  package WaterLib
   extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-90,42},{72,-84}},
              fileName="modelica://Physiolibrary/Resources/Icons/indexVoda.png")}));

  end WaterLib;

   package KidneyLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,42},{72,-96}},
              fileName="modelica://Physiolibrary/Resources/Icons/Kidney.png")}));

   end KidneyLib;

  package ElectrolytesLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-78,38},{64,-94}},
              fileName="modelica://Physiolibrary/Resources/Icons/electrolytes.png")}));

  end ElectrolytesLib;

  package GasesLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-88,34},{66,-82}},
              fileName="modelica://Physiolibrary/Resources/Icons/gases.png")}));

  end GasesLib;

  package GolemLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,42},{78,-98}},
              fileName="modelica://Physiolibrary/Resources/Icons/golem.png")}));
  end GolemLib;

  package BaseLib
    extends Modelica.Icons.Package;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics));
  end BaseLib;

  package HormonesLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-88,30},{74,-88}},
              fileName="modelica://Physiolibrary/Resources/Icons/hormony.png")}));

  end HormonesLib;

   package AutonomicControlLib
    extends BaseLib;
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-96,42},{72,-96}},
              fileName="modelica://Physiolibrary/Resources/Icons/sympatetickeNervy.png")}));

   end AutonomicControlLib;

  partial model Resistor

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={
          Rectangle(
            extent={{-70,30},{70,-30}},
            lineColor={0,0,0},
            fillColor={241,241,241},
            fillPattern=FillPattern.Solid),
          Line(points={{-90,0},{-70,0}}, color={0,0,0}),
          Line(points={{70,0},{90,0}}, color={0,0,0})}));
  end Resistor;

  model Lymph

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/Lymph.png")}));
  end Lymph;

  model RespiratoryCenter

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/respiracniCentrum.png")}));
  end RespiratoryCenter;

  model Oxygen

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={
                    Bitmap(extent={{-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/O2.png")}));
  end Oxygen;

  model CarbonDioxide

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={
                    Bitmap(extent={{-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/prvkyCO2.png")}));
  end CarbonDioxide;

  model AcidBase

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={
                    Bitmap(extent={{-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/acidobaze.png")}));
  end AcidBase;

  model Ventilation

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/dychani.png")}));
  end Ventilation;

  model PeripheralChemoreceptors

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/baroreflex.png")}));
  end PeripheralChemoreceptors;

  model HeatCore

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{
              -100,-100},{100,100}}), graphics={Bitmap(extent={{-100,100},{
                100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/torzo2.png")}));
  end HeatCore;

  model Glycogen

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={
                               Rectangle(
            extent={{-100,100},{100,-100}},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None),     Bitmap(extent={{-100,100},{100,-100}},
                        fileName=
                "modelica://Physiolibrary/Resources/Icons/glykogen.png")}));
  end Glycogen;

  model Lipids

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/FattyAcid.png")}));
  end Lipids;

  model KetoAcids

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/KetoAcid.png")}));
  end KetoAcids;

  model Glucose

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/glucose.png")}));
  end Glucose;

  model Lactate

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/Lactate.png")}));
  end Lactate;

  model AminoAcids

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/AminoAcid.png")}));
  end AminoAcids;

  model Urea

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/Urea.png")}));
  end Urea;

  model MetabolismPart

    annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
              {100,120}}),            graphics), Icon(coordinateSystem(
            preserveAspectRatio=true, extent={{-100,-100},{100,120}}),
          graphics={             Bitmap(extent={{28,120},{98,44}}, fileName=
               "modelica://Physiolibrary/Resources/Icons/ohen.png")}));
  end MetabolismPart;

  model CellularMetabolism

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/cellularMetabolism.png")}));
  end CellularMetabolism;

  model FemaleSex

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/hormonesFemaleSex.png")}));
  end FemaleSex;

  model Barroreceptor

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/baroreflex.png")}));
  end Barroreceptor;

  model NervusVagus

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/vagus.png")}));
  end NervusVagus;

  model SympatheticNerves

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/sympatetickeNervy.png")}));
  end SympatheticNerves;

  model PhysicalExercise

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/cviceni.png")}));
  end PhysicalExercise;

  model SinoatrialNode

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/SANode.png")}));
  end SinoatrialNode;

  block StatusNormal

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaNormal.png")}));
  end StatusNormal;

  block StatusConfused

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaZmateni.png")}));
  end StatusConfused;

  block StatusImpaired

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaVaznejsiStav.png")}));
  end StatusImpaired;

  block StatusNotBreathing

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaNedychaSam.png")}));
  end StatusNotBreathing;

  block StatusComatose

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaKoma.png")}));
  end StatusComatose;

  block StatusMayBeDead

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaSkoroMrtvy.png")}));
  end StatusMayBeDead;

  block StatusIsReallyDead

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/siluetaMrtvy.png")}));
  end StatusIsReallyDead;

  model SkeletalMuscleAcidity

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/kyselostVeSvalech.png")}));
  end SkeletalMuscleAcidity;

  model Sodium

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/Na.png")}));
  end Sodium;

  model Potassium

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/K.png")}));
  end Potassium;

  model Phosphate

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/fosfat.png")}));
  end Phosphate;

  model Sulphate

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/sulfat02.png")}));
  end Sulphate;

  model Amonium

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/NH4.png")}));
  end Amonium;

  model Chloride

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/Cl.png")}));
  end Chloride;

  model LungShunt

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/lungBloodFlow.png")}));
  end LungShunt;

  model Hydrostatics

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/pressureMeassure.png")}));
  end Hydrostatics;

  model UpperTorso

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/torzo1.png")}));
  end UpperTorso;

  model MiddleTorso

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/torzo2.png")}));
  end MiddleTorso;

  model LowerTorso

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName="modelica://Physiolibrary/Resources/Icons/torzo3.png")}));
  end LowerTorso;

  model RedCells

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/cervenaKrvinka.png")}));
  end RedCells;

  model SystemicCirculation

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/krevniRecisteSiluetacloveka.png")}));
  end SystemicCirculation;

  model PulmonaryCirculation

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/krevniRecistePlice.png")}));
  end PulmonaryCirculation;

  model Blood

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/bloodProperties.png")}));
  end Blood;

  model BaseFactorIcon0

    annotation (Icon(graphics={  Rectangle(
            extent={{-100,60},{100,-40}},
            lineColor={0,127,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Sphere), Text(
            extent={{-76,44},{64,-22}},
            lineColor={0,0,0},
            textString="%name")}));
  end BaseFactorIcon0;

  partial model BaseFactorIcon

    Modelica.Blocks.Interfaces.RealInput yBase
                     annotation (Placement(transformation(extent={{-20,-20},{
              20,20}},
          rotation=270,
          origin={0,20})));
    Modelica.Blocks.Interfaces.RealOutput y
                  annotation (Placement(transformation(extent={{-20,-20},{20,
              20}},
          rotation=270,
          origin={0,-40})));

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Rectangle(
            extent={{-100,20},{100,-20}},
            lineColor={95,95,95},
            fillColor={255,255,255},
            fillPattern=FillPattern.Sphere), Text(
            extent={{-90,-10},{92,10}},
            textString="%name",
            lineColor={0,0,0})}), Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
          graphics));
  end BaseFactorIcon;

  partial model BaseFactorIcon2

    Modelica.Blocks.Interfaces.RealInput yBase
                     annotation (Placement(transformation(extent={{-20,-20},{
              20,20}},
          rotation=270,
          origin={0,60})));
    Modelica.Blocks.Interfaces.RealOutput y
                  annotation (Placement(transformation(extent={{-20,-20},{20,
              20}},
          rotation=270,
          origin={0,-60})));

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Rectangle(
            extent={{-100,50},{100,-50}},
            lineColor={0,127,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Sphere), Text(
            extent={{-86,-36},{100,40}},
            textString="%name",
            lineColor={0,0,0},
            fillPattern=FillPattern.Sphere)}), Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
          graphics));
  end BaseFactorIcon2;

  partial model BaseFactorIcon3

    Modelica.Blocks.Interfaces.RealInput yBase
                     annotation (Placement(transformation(extent={{-20,-20},{
              20,20}},
          rotation=270,
          origin={0,20})));
    Modelica.Blocks.Interfaces.RealOutput y
                  annotation (Placement(transformation(extent={{-20,-20},{20,
              20}},
          rotation=270,
          origin={0,-40})));

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Rectangle(
            extent={{-100,20},{100,-20}},
            lineColor={0,127,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Sphere), Text(
            extent={{-90,-10},{92,10}},
            textString="%name",
            lineColor={0,0,0})}), Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
          graphics));
  end BaseFactorIcon3;

  partial model BaseFactorIcon4

    Modelica.Blocks.Interfaces.RealInput yBase
                     annotation (Placement(transformation(extent={{-20,-20},{
              20,20}},
          rotation=270,
          origin={0,20})));
    Modelica.Blocks.Interfaces.RealOutput y
                  annotation (Placement(transformation(extent={{-20,-20},{20,
              20}},
          rotation=270,
          origin={0,-40})));

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Rectangle(
            extent={{-100,20},{100,-20}},
            lineColor={127,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Sphere), Text(
            extent={{-90,-10},{92,10}},
            textString="%name",
            lineColor={0,0,0})}), Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
          graphics));
  end BaseFactorIcon4;

  partial model BaseFactorIcon5

    Modelica.Blocks.Interfaces.RealInput yBase
                     annotation (Placement(transformation(extent={{-20,-20},{
              20,20}},
          rotation=270,
          origin={0,20})));
    Modelica.Blocks.Interfaces.RealOutput y
                  annotation (Placement(transformation(extent={{-20,-20},{20,
              20}},
          rotation=270,
          origin={0,-40})));

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Rectangle(
            extent={{-100,20},{100,-20}},
            lineColor={0,0,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Sphere), Text(
            extent={{-90,-10},{92,10}},
            textString="%name",
            lineColor={0,0,0})}), Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
          graphics));
  end BaseFactorIcon5;

  partial model BaseFactorIcon6

    Modelica.Blocks.Interfaces.RealInput yBase
                     annotation (Placement(transformation(extent={{-20,-20},{
              20,20}},
          rotation=270,
          origin={0,20})));
    Modelica.Blocks.Interfaces.RealOutput y
                  annotation (Placement(transformation(extent={{-20,-20},{20,
              20}},
          rotation=270,
          origin={0,-40})));

   annotation (
      Icon(coordinateSystem(
          preserveAspectRatio=true,
          extent={{-100,-100},{100,100}},
          grid={2,2}), graphics={Rectangle(
          extent={{-100,20},{100,-20}},
          lineColor={0,87,87},
          fillColor={255,255,255},
          fillPattern=FillPattern.Sphere)}),
                                  Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-100},{100,100}}),
          graphics));
  end BaseFactorIcon6;

  partial class ConversionIcon "Base icon for conversion functions"

    annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,100},{100,-100}},
            lineColor={191,0,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Line(points={{-74,0},{30,0}}, color={191,0,0}),
          Polygon(
            points={{80,0},{20,20},{20,-20},{80,0}},
            lineColor={191,0,0},
            fillColor={191,0,0},
            fillPattern=FillPattern.Solid)}));

  end ConversionIcon;

  partial model Diffusion

    annotation (Icon(graphics={Bitmap(extent={{-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/diffusion.png")}));

  end Diffusion;

  model Substance

      annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics), Icon(coordinateSystem(
            preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
          graphics={Bitmap(extent={{-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/Concentration.png"), Text(
            extent={{-22,-102},{220,-136}},
            lineColor={0,0,255},
            textString="%name")}));
  end Substance;

  model Speciation

    annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}}), graphics), Icon(coordinateSystem(
            preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
          graphics={Bitmap(extent={{-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/Speciation.png"), Text(
            extent={{-182,-84},{60,-118}},
            lineColor={0,0,255},
            textString="%name")}));
  end Speciation;

  model MolarFlowMeasure

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/molarFlowMeassure.png")}));
  end MolarFlowMeasure;

  model GasSolubility

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/GasSolubility.png")}));
  end GasSolubility;

  model Reabsorption

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/reabsorption.png")}));
  end Reabsorption;

  model Reabsorption2

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/reabsorption.png")}));
  end Reabsorption2;

  model Dilution

    annotation (Icon(graphics={     Bitmap(extent={{-100,101},{100,-101}},
              fileName="modelica://Physiolibrary/Resources/Icons/dilution.png",
            origin={0,33},
            rotation=270)}));
  end Dilution;

  model ElasticBalloon

  annotation (Icon(graphics={     Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/elastickyKompartment - Kopie.png")}));
  end ElasticBalloon;

  model BloodElasticCompartment

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/elastickyKompartment.png")}));
  end BloodElasticCompartment;

  model BloodSequesteredCompartment

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,
                -100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/sequerestedVolume.png")}));
  end BloodSequesteredCompartment;

  partial model HydraulicResistor

  annotation (Icon(graphics={    Bitmap(extent={{-120,44},{120,-42}},
              fileName="modelica://Physiolibrary/Resources/Icons/resistance.png")}));
  end HydraulicResistor;

  model FlowMeasure

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={
                                    Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/flowMeassure.png")}));
  end FlowMeasure;

  model Membrane

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/membrane.png")}));
  end Membrane;

  model PressureMeasure

    annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{
              -100,-100},{100,100}}), graphics), Icon(graphics={Bitmap(extent={
                {-100,100},{100,-100}}, fileName=
                "modelica://Physiolibrary/Resources/Icons/pressureMeassure.png")}));
  end PressureMeasure;

  model InternalElasticBalloon

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/ventilatorCapacitance.png")}));
  end InternalElasticBalloon;

  model Inertance

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/ventilatorInertance.png")}));
  end Inertance;

  model HydrostaticGradient

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
              {100,100}}), graphics={Bitmap(extent={{-100,100},{102,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/hydrostaticGradient.png")}));

  end HydrostaticGradient;

  model Radiator

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/Radiator.png")}));
  end Radiator;

  model MichaelisMenten

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-80,84},{86,-26}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/MichaelisMenten.png")}));
  end MichaelisMenten;

  model HeatAccumulation

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/HeatAccumulation.png")}));
  end HeatAccumulation;

  model OsmoticCell

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/OsmothicCell.png")}));
  end OsmoticCell;

  model IdealGas

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName="modelica://Physiolibrary/Resources/Icons/IdealGas.png")}));
  end IdealGas;

  model PartialPressure

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={Bitmap(extent={{-100,100},{100,-100}},
              fileName=
                "modelica://Physiolibrary/Resources/Icons/PartialPressure.png")}));
  end PartialPressure;

  model ConservationLaw

    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
              -100},{100,100}}), graphics={
          Rectangle(
            extent={{-100,100},{100,-100}},
            fillColor={170,255,213},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None),
          Polygon(
            points={{-40,-60},{-40,-20},{-80,-40},{-40,-60}},
            pattern=LinePattern.None,
            smooth=Smooth.None,
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,0}),
          Line(
            points={{-80,10},{-80,-80},{-80,-80}},
            color={0,0,0},
            smooth=Smooth.None)}));
  end ConservationLaw;
  annotation (Documentation(revisions=""));
end Icons;
